import java.io.*;
import rockey2.JRockey2;

public class Sample
{
    public static void main(String[] args)
    {
    	int  iRetcode, iBlock_index;
    	int  iHandle;
    	int[]  iUid = new int[10], iHid = new int[10];
    	byte[] cBuffer = new byte[513];
    	
    	JRockey2 rockey=new JRockey2();
		
    	System.out.println();
    	System.out.println("..........................generate UID.........................");
	System.out.println("...............................................................");

	System.out.println("Find rockey2...............................");
        iRetcode = rockey.RY2_Find();
        if(iRetcode < 0)
        {
            System.out.println("ERROR: " + Integer.toHexString(iRetcode));
            return;
        }
        if(iRetcode == 0)
        {
            System.out.println("ERROR: Not found any rockey2");
            return;
        }
        System.out.println("Find rockey2.............................ok");
        System.out.println();
        
	// when generate UID, only one dongle should be inserted to computer
	// so we do not cared what UID and HID is. 
	// we just use the dongle we find fisrt.
	System.out.println("We only use the first rockey2..............");
	System.out.println("open the rockey2...........................");
     	iRetcode = rockey.RY2_Open(rockey.AUTO_MODE, 0, iHid);
        if(iRetcode < 0)
        {
             System.out.println("ERROR: " + Integer.toHexString(iRetcode));
             return;
        }
        System.out.println("open the rockey2.........................ok");
        System.out.println();
        
        iHandle = iRetcode;
        System.out.println("Getuid....................................");
	System.out.println("We use the seed = 12345");
	System.out.println("Note:The seed code must not be longer than 64bytes!");
        cBuffer[0] = '1';
	cBuffer[1] = '2';
	cBuffer[2] = '3';
	cBuffer[3] = '4';
	cBuffer[4] = '5';
	cBuffer[5] = '\0';
        iRetcode = rockey.RY2_GenUID(iHandle, iUid, cBuffer, rockey.ROCKEY2_DISABLE_WRITE_PROTECT);
 	if (iRetcode < 0)
	{
	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
	    return;
	}
	System.out.println("Getuid...................................ok");
	System.out.println("\nUID is:" + iUid[0]);
	System.out.println();
		
	System.out.println("close rockey2..............................");
	rockey.RY2_Close(iHandle);
	System.out.println("close rockey2............................ok");
	System.out.println();
		
	// after generating a new UID, the flag of dongle will change, we have to re-plug it
	System.out.println("You must plug out Rockey2 and re-plug to enable new uid.");
        System.out.println();

        System.out.println("..............write dongle with appointed UID..................");
	System.out.println("...............................................................");
	System.out.println("Find rockey2...............................");
	iRetcode = rockey.RY2_Find();
	if (iRetcode < 0)
	{
	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
	    return;
	}
	if (iRetcode == 0)
	{
	    System.out.println("ERROR: Not found any rockey2");
	    return;
	}
	System.out.println("Find rockey2.............................ok");
	System.out.println();
	System.out.println("open the rockey2...........................");
        iRetcode = rockey.RY2_Open(1, iUid[0], iHid);
	if (iRetcode < 0)
	{
	    System.out.println("ERROR: " + iRetcode);
	    return;
	}
	System.out.println("open the rockey2.........................ok");
	System.out.println();
	
	iHandle = iRetcode;
	iBlock_index = 0;
        cBuffer[0] = '0';
	cBuffer[1] = '1';
	cBuffer[2] = '2';
	cBuffer[3] = '3';
	cBuffer[4] = '4';
	cBuffer[5] = '5';
        cBuffer[6] = '6';
	cBuffer[7] = '7';
	cBuffer[8] = '8';
	cBuffer[9] = '9';
	cBuffer[10] = '\0';
	System.out.println("Write string(\"0123456789\") to rockey2......");
	System.out.println("Note:The data written to each block must not be longer than 512bytes!");
	iRetcode = rockey.RY2_Write(iHandle, iBlock_index, cBuffer);
	if (iRetcode < 0)
	{
	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
	    return;
	}
	System.out.println("Write....................................ok");
	System.out.println();
		
	System.out.println("close rockey2..............................");
	rockey.RY2_Close(iHandle);
	System.out.println("close rockey2............................ok");
	System.out.println();
		

        System.out.println("...............read dongle with appointed UID..................");
	System.out.println("...............................................................");
	System.out.println("Find rockey2...............................");
	iRetcode = rockey.RY2_Find();
	if (iRetcode < 0)
	{
	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
	    return;
	}
	if (iRetcode == 0)
	{
	    System.out.println("ERROR: Not found any rockey2");
	    return;
	}
        System.out.println("Find rockey2.............................ok");
        System.out.println();
	System.out.println("open the rockey2...........................");
	iRetcode = rockey.RY2_Open(1, iUid[0], iHid);
	if (iRetcode < 0)
	{
	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
	    return;
	}
	System.out.println("open the rockey2.........................ok");
	System.out.println();
	iHandle = iRetcode;
	iBlock_index = 0;
        System.out.println("Read data..................................");
	iRetcode = rockey.RY2_Read(iHandle, iBlock_index, cBuffer);
	if (iRetcode < 0)
	{
	    System.out.println("ERROR: " + Integer.toHexString(iRetcode));
	    return;
	}
	System.out.println("Read data................................ok");
	System.out.println("Readed data: " + (new String(cBuffer, 0, BufLen(cBuffer, 512))));
	System.out.println();
		
	System.out.println("close rockey2..............................");
	rockey.RY2_Close(iHandle);
	System.out.println("close rockey2............................ok");	
    }

    //find blank character in buf, and return the length.
    public static int BufLen(byte[] buffer, int len)
    {
        int i = 0;
	for (i=0; i<len && buffer[i]!=0; i++);
	return i;
    }
}

